unit Unit1;

interface

{==============================================================================}
{ This demo shows mouse events, not connected with hypertext IDs               }
{ - OnRVMouseDown, OnRVMouseUp, OnRVDblClick, OnRVRightClick;                  }
{------------------------------------------------------------------------------}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, RVScroll, RichView, RVStyle, RVTypes, StdCtrls,
  CRVFData, SclRView, RVUni;

{$I RV_Defs.inc}

type
  TForm1 = class(TForm)
    panMouseDown: TPanel;
    panMouseUp: TPanel;
    panRightClick: TPanel;
    panDblClick: TPanel;
    RVStyle1: TRVStyle;
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    srv: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure RichView1RVMouseDown(Sender: TCustomRichView; Button: TMouseButton;
      Shift: TShiftState; ItemNo, X, Y: Integer);
    procedure RichView1RVMouseUp(Sender: TCustomRichView; Button: TMouseButton;
      Shift: TShiftState; ItemNo, X, Y: Integer);
    procedure RichView1RVDblClick(Sender: TCustomRichView;
      ClickedWord: TRVRawByteString; Style: Integer);
    procedure RichView1RVRightClick(Sender: TCustomRichView;
      ClickedWord: TRVRawByteString; Style, X, Y: Integer);
  private
    { Private declarations }
    function MouseInfo(Button: TMouseButton; Shift: TShiftState; ItemNo, X, Y: Integer):String;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var ico: TIcon;
begin
  srv.SetMargin(5, 5, 5, 5);

  srv.RichViewEdit.AddNL('More mouse events',1,1);
  srv.RichViewEdit.AddTextNL('There are some more mouse events in RichView'#13+
    'Left/Right/Double - click in this Window.',0,0,0);

  ico := TIcon.Create;
  ico.Assign(Image1.Picture.Graphic);
  srv.RichViewEdit.AddPictureEx('Notebook image',ico,1, rvvaMiddle);
  srv.RichViewEdit.Add(' - example of image',0);

  srv.RichViewEdit.Format;
end;

function TForm1.MouseInfo(Button: TMouseButton; Shift: TShiftState; ItemNo, X, Y: Integer): String;
var ButtonStr, Word: String;
begin
  ButtonStr := '';
  case Button of
    mbLeft:
      ButtonStr := 'Left button';
    mbRight:
      ButtonStr := 'Right button';
    mbMiddle:
      ButtonStr := 'Middle button';
  end;

  if ItemNo<>-1 then begin
    Word := srv.RichViewEdit.GetWordAt(X,Y);
    Result := Format('%s at (%d,%d), at item #%d, at word "%s"',
      [ButtonStr, X,Y, ItemNo, Word]);
    end
  else
    Result := Format('%s at (%d,%d) - no item at this position',
      [ButtonStr, X,Y]);
end;

procedure TForm1.RichView1RVMouseDown(Sender: TCustomRichView;
  Button: TMouseButton; Shift: TShiftState; ItemNo, X, Y: Integer);
begin
  panMouseDown.Caption := 'MouseDown: '+MouseInfo(Button, Shift, ItemNo, X, Y);
end;

procedure TForm1.RichView1RVMouseUp(Sender: TCustomRichView;
  Button: TMouseButton; Shift: TShiftState; ItemNo, X, Y: Integer);
begin
  panMouseUp.Caption := 'MouseUp: '+MouseInfo(Button, Shift, ItemNo, X, Y);
end;

// Converting text from internal representation to String
function ConvertItemTextToString(const ItemText: TRVRawByteString;
  UnicodeItem: Boolean; CodePage: Cardinal): String;
begin
  {$IFDEF RVUNICODESTR} // <-- declared in RV_Defs.inc
  // Delphi 2009+: String is Unicode
  if UnicodeItem then
    Result := RVU_RawUnicodeToWideString(ItemText)
  else
    Result := RVU_RawUnicodeToWideString(
      RVU_AnsiToUnicode(CodePage, ItemText));
  {$ELSE}
  // Delphi 4-2007: String is ANSI
  if UnicodeItem then
    Result := RVU_UnicodeToAnsi(CodePage, ItemText)
  else
    Result := ItemText;
  {$ENDIF}
end;

procedure TForm1.RichView1RVDblClick(Sender: TCustomRichView;
  ClickedWord: TRVRawByteString; Style: Integer);
var s: String;
begin
  s := ConvertItemTextToString(ClickedWord,
    (Style>=0) and RVStyle1.TextStyles[Style].Unicode,
    RVStyle1.DefCodePage);
  panDblClick.Caption :=
    Format('DoubleClick: at word="%s", at item having style=%d', [s,Style]);
end;

// This event is obsolete. Use OnRVMouseUp instead
procedure TForm1.RichView1RVRightClick(Sender: TCustomRichView;
  ClickedWord: TRVRawByteString; Style, X, Y: Integer);
var s: String;
begin
  s := ConvertItemTextToString(ClickedWord,
    (Style>=0) and RVStyle1.TextStyles[Style].Unicode,
    RVStyle1.DefCodePage);
  panRightClick.Caption :=
    Format('RightClick: at (%d,%d), at word="%s", at item having style=%d',
      [X,Y,s,Style]);
end;

end.
